---
name: content-pillar-mapper
version: 1.0.0
---

# Initialization

Content Pillar Mapper is an AI skill for building strategic content pillars aligned with buyer journey stages. It helps content strategists, B2B marketers, and SEO professionals create topic clusters, hub-and-spoke architecture, and establish topical authority for organic traffic and lead generation.

## Structure

- `SKILL.md` - Main skill prompt with complete content pillar mapping framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r content-pillar-mapper/ ~/.claude/skills/content-pillar-mapper/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant (Claude, ChatGPT, Gemini, Copilot)

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{num_pillars}}` | `4` | Number of core content pillars to develop (typically 3-5) |
| `{{cluster_depth}}` | `6` | Number of subtopic articles per pillar |
| `{{journey_stages}}` | `4` | Number of buyer journey stages to map |
| `{{avg_pillar_length}}` | `3500` | Target word count for pillar pages |
| `{{content_refresh_cycle}}` | `quarterly` | How often to audit and refresh content |
| `{{internal_link_target}}` | `15` | Average internal links from pillar to clusters |

## Capabilities

This skill enables you to:

1. **Pillar Selection & Strategic Definition** - Identify and define 3-5 core content pillars aligned with business goals and audience needs
2. **Buyer Journey Mapping** - Map content needs and themes across awareness, consideration, decision, and loyalty stages
3. **Topic Cluster Development** - Create comprehensive topic clusters with 5-8 supporting subtopic articles per pillar
4. **Content Audit & Gap Analysis** - Assess existing content and identify missing pieces within the pillar strategy
5. **Content Roadmap Creation** - Build prioritized 6-month content roadmaps with gap analysis
6. **Performance Tracking** - Measure content pillar effectiveness by stage and optimize based on data

## Quick Start

After installation, try this prompt:

```
We're a B2B SaaS company selling HR software to mid-market companies.
Our target buyers are HR Directors and CHROs. Create a content pillar
mapping strategy with 4 pillars covering employee engagement, talent
acquisition, performance management, and compliance. Map each pillar
to the buyer journey and identify 6 cluster topics per pillar.
```

## Key Concepts

- **Content Pillar**: Foundational topic establishing deep brand expertise (hub in hub-and-spoke model)
- **Topic Cluster**: Pillar page + 5-8 supporting subtopic articles, all interlinked
- **Hub-and-Spoke Model**: Central pillar page linked to/from multiple subtopic articles
- **Topical Authority**: SEO concept where website demonstrates comprehensive expertise across subject area
- **Buyer's Journey Stages**: Awareness → Consideration → Decision → Loyalty

## Best Practices

- Start with deep audience research before selecting pillars
- Select only 3-5 pillars maximum (depth over breadth)
- Build comprehensive pillar pages (2,500-5,000+ words)
- Create 5-8 substantial cluster articles per pillar (1,500+ words each)
- Implement strategic internal linking throughout
- Refresh and update content regularly (quarterly minimum)
- Expect 6-12 months for meaningful SEO results

---
Downloaded from [Find Skill.ai](https://findskill.ai)
