---
name: comment-reply-bot
version: 1.0.0
---

# Comment Reply Bot - Initialization

Generate witty, neutral, or strategic responses to trolls and negative comments so you don't respond emotionally. This skill helps content creators and social media managers handle negativity while protecting mental health and maintaining engagement.

## Structure

```
comment-reply-bot/
├── SKILL.md    # Main skill prompt (copy into AI assistant)
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r comment-reply-bot/ ~/.claude/skills/comment-reply-bot/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into Claude, ChatGPT, Gemini, or Copilot
4. Start providing negative comments to analyze

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `platform` | `twitter` | Social media platform (twitter, youtube, instagram, tiktok, reddit, linkedin) |
| `response_tone` | `witty` | Response style: witty, professional, educational, humorous, deadpan, savage |
| `brand_voice` | `casual and clever` | Your personal brand voice description |
| `max_length` | `280` | Maximum response length in characters |
| `escalation_threshold` | `threat keywords` | Terms that trigger escalation instead of response |

## Quick Start

After installing, try this prompt:

```
Someone commented "Your video is garbage and so are you" on my latest YouTube video.
Generate 3 response options: one witty/dismissive, one professional, and one
self-deprecating. My brand voice is sarcastic but not mean.
```

## What This Skill Does

1. **Classifies comments** into 5 categories (troll, angry-but-valid, coordinated harassment, threats, spam)
2. **Generates multiple response options** in different tones for you to choose
3. **Recommends actions** (reply, ignore, block, escalate)
4. **Adapts to platforms** (Twitter, YouTube, Instagram, TikTok, Reddit, LinkedIn)
5. **Protects mental health** with reframing techniques and boundary-setting advice

## Key Features

- **WITS Method**: Wit Over Anger, Intent Recognition, Tone Matching, Short & Devastating
- **40+ Response Templates** across 5 tone categories
- **Platform-Specific Adaptations** for character limits and norms
- **Threat Escalation Protocol** for dangerous content
- **Psychological Protection Strategies** for emotional wellbeing

## Example Output

```
COMMENT ANALYSIS
================
Original Comment: "Your video is garbage and so are you"
Category: 1 (Pure Trolling - No Substance)
Toxicity Level: High
Valid Point Present: No
Recommended Action: Reply with witty dismissal or ignore

RESPONSE OPTIONS
================
Option A (Witty): "Thanks for the detailed critique. Really thorough work here."
Option B (Professional): "Thanks for sharing your perspective. I appreciate you engaging."
Option C (Self-Deprecating): "You think THIS is bad? You should see my drafts folder."

RECOMMENDATION
================
Best choice: A (Witty)
Reasoning: Pure troll with no substance - brief dismissal denies them the emotional reaction they seek
Timing: Respond within 2 hours for algorithm boost, or ignore entirely
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
