---
name: brand-voice-tone-guide-generator
version: 1.0.0
---

# Brand Voice & Tone Guide Generator

Create comprehensive, professional-grade brand voice and tone documentation using proven frameworks like WILD and Four Dimensions. Generate personality trait definitions, tone variation matrices, vocabulary standards, do's/don'ts, channel-specific guidelines, and team implementation materials.

## Structure

```
brand-voice-tone-guide-generator/
├── SKILL.md      # Main skill prompt (comprehensive brand voice guide generator)
└── INIT.md       # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### Claude Code
```bash
# Copy to Claude Code skills directory
cp -r brand-voice-tone-guide-generator/ ~/.claude/skills/brand-voice-tone-guide-generator/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{brand_industry}}` | `technology` | Industry context (technology, healthcare, finance, retail, nonprofit, etc.) |
| `{{brand_stage}}` | `growth` | Company stage (startup, growth, established, enterprise) |
| `{{personality_traits}}` | `authentic, approachable, professional` | 3-5 core brand personality traits |
| `{{target_audience}}` | `B2B professional decision-makers` | Primary audience description |
| `{{communication_channels}}` | `website, social_media, email, customer_support` | Channels requiring voice guidelines |
| `{{tone_formality}}` | `6` | Formality level 1-10 (1=very casual, 10=very formal) |

## Key Frameworks

### WILD Framework
- **W**ords: Vocabulary, approved terms, words to avoid
- **I**-sms: Quirks, characteristic expressions, signature phrases
- **L**ength: Sentence structure, paragraph approach, brevity preferences
- **D**elivery: How personality comes through, tone positioning

### Four Dimensions
Position brand on four independent spectrums:
1. Funny ↔ Serious
2. Formal ↔ Casual
3. Respectful ↔ Irreverent
4. Enthusiastic ↔ Matter-of-Fact

## Core Capabilities

1. **Brand Personality Definition** - Define 3-5 traits with supporting examples
2. **Tone Variation Mapping** - Create context-specific tone matrices
3. **Vocabulary Standardization** - Generate use/avoid lists with alternatives
4. **Do's & Don'ts Generation** - Practical guidelines with real examples
5. **Channel-Specific Guidelines** - Adapt voice for different platforms
6. **Team Implementation Materials** - Checklists, training outlines
7. **AI Integration Guidance** - System prompts for AI-assisted consistency

## Example Usage

```
Create comprehensive brand voice guidelines for TechFlow, a project management SaaS startup.

Brand personality: authentic, innovative, human-centered
Target audience: busy mid-level managers (25-45) skeptical of tech buzzwords
Channels: website, product interface, support emails, LinkedIn

We want to sound like we understand their problems (not corporate-speak).
We value transparency and admit when things are difficult.

Generate a complete voice guide with personality breakdown, tone variations,
do's/don'ts, vocabulary standards, and implementation materials.
```

## Output Structure

Generated guides typically include:
1. Executive Summary (1 page)
2. Personality Deep-Dive (2-3 pages)
3. Tone Variation Guide (1-2 pages)
4. Vocabulary Standards (1-2 pages)
5. Do's and Don'ts (1-2 pages)
6. Channel Guidelines (2-3 pages)
7. Implementation Resources (1-2 pages)
8. AI Integration (1 page, if applicable)

Total: 10-18 pages of actionable, example-rich guidance

## Related Skills

- **Brand Voice** - Basic voice development and maintenance
- **Copywriter Pro** - Expert copywriting for marketing contexts
- **Content Creator** - SEO-optimized content with brand consistency
- **Social Media Content Calendar** - Platform-specific content planning

---
Downloaded from [Find Skill.ai](https://findskill.ai)
